{
	"iceTower":{
		"type":"defenseTower",
		"age":"etherAge",
		"no":11.2,
		"picture":{"file":"iceTower.png",
				   "file100":"iceTower100.atf"},
		"name":{"EN":"ice tower",
				"FR":"tour de glace"},
		"description":{"EN":"The ice tower slow down the invaders.",
					   "FR":"La tour de glace ralenti les envahisseurs."},
		"build":{
			"chooseLocation":true,
			"buildable":"all",
			"costRessource":{"crystals":250},
			"costPrimaryCharacteristic":{"stamina":4},
			"sound":"soundBuilding",
			"bonusSkill":"building",
			"xpSkill":{"building":4},
			"xpSecondaryCharacteristic":{"strength":4},
			"prebuild":{"id":"iceTowerYard", "time":2}
		},
		"repair":{
			"health":8,
			"time":2,
			"costRessource":{"crystals":1},
			"costPrimaryCharacteristic":{"stamina":4},
			"sound":"soundBuilding",
			"bonusSkill":"repairing",
			"xpSkill":{"repairing":4},
			"xpSecondaryCharacteristic":{"endurance":4}
		},
		"death":{
			"effect":{"name":"destruction", "scale":1.25}
		},
		"width":80,
		"height":136,
		"visualHeight":160,
		"health":2000,
		"attack":400, "special":{"selfGuided":0.05, "penality":{"id":"slowdown", "time":5}}, 
		"attackTime":3, "range":500, "missile":"iceBolt", "attackDX":3, "attackDY":-160,
		"damage":["magic", "ice"],
		"defense":200,
		"resistance":{"magic":0.5, "explosion":2, "poison":0}
	},
	"iceTowerYard":{
		"type":"prebuild",
		"picture":{"file":"iceTowerYard.png",
				   "file100":"iceTowerYard100.atf"},
		"name":{"EN":"ice tower",
				"FR":"tour de glace"},
		"description":{"EN":"The ice tower slow down the invaders.",
					   "FR":"La tour de glace ralenti les envahisseurs."},
		"death":{
			"effect":{"name":"destruction", "scale":1.25}
		},
		"width":80,
		"height":136,
		"visualHeight":160,
		"defense":200,
		"steps":3,
		"resistance":{"magic":0.5, "explosion":2, "poison":0}
	},
	"artillery":{
		"type":"defenseTower",
		"age":"steamAge",
		"no":17,
		"picture":{"file":"artillery.png",
				   "file100":"artillery100.atf"},
		"name":{"EN":"artilley",
				"FR":"artillerie"},
		"description":{"EN":"The artilley is a defense tower which shoot long range sheels.",
					   "FR":"L'artillerie est une tourelle qui tire des obus de longue portée."},
		"rotateTower":{"file":"artilleryTower.png",
					   "file100":"artilleryTower100.atf",
					   "steps":4,
					   "effect":"shootSmoke",
					   "x":0,
					   "y":-144,
					   "pivotX":57,
					   "pivotY":31,
					   "startingRotation":1.57,
					   "width":220,
					   "height":60,
					   "length":160,
					   "speed":0.01},
		"build":{
			"chooseLocation":true,
			"buildable":"all",
			"costRessource":{"steel":2000},
			"costPrimaryCharacteristic":{"stamina":3},
			"sound":"soundBuilding",
			"bonusSkill":"building",
			"xpSkill":{"building":3},
			"xpSecondaryCharacteristic":{"strength":3},
			"prebuild":{"id":"artilleryYard", "time":1.5}
		},
		"repair":{
			"health":2,
			"time":1.5,
			"costRessource":{"steel":1},
			"costPrimaryCharacteristic":{"stamina":3},
			"sound":"soundBuilding",
			"bonusSkill":"repairing",
			"xpSkill":{"repairing":3},
			"xpSecondaryCharacteristic":{"endurance":3}
		},
		"death":{
			"effect":{"name":"destruction", "scale":2}
		},
		"width":180,
		"height":155,
		"visualHeight":186,
		"health":4000,
		"attack":20000, "special":{"selfGuided":0.0001, "pierce":true}, "attackTime":20, "range":60000, "missile":"bombshell", "attackDY":-144,
		"damage":["missile", "explosion"],
		"defense":250,
		"resistance":{"fire":1.5, "death":0.5, "electricity":1.5, "explosion":2, "poison":0}
	},
	"artilleryYard":{
		"type":"prebuild",
		"picture":{"file":"artilleryYard.png",
				   "file100":"artilleryYard100.atf"},
		"name":{"EN":"artilley",
				"FR":"artillerie"},
		"description":{"EN":"The artilley is a defense tower which shoot long range sheels.",
					   "FR":"L'artillerie est une tourelle qui tire des obus de longue portée."},
		"death":{
			"effect":{"name":"destruction", "scale":2}
		},
		"width":180,
		"height":155,
		"visualHeight":186,
		"defense":250,
		"resistance":{"fire":1.5, "death":0.5, "electricity":1.5, "explosion":2, "poison":0},
		"steps":2
	},
	"sniperTower":{
		"type":"defenseTower",
		"age":"steamAge",
		"no":15,
		"picture":{"file":"sniperTower.png",
				   "file100":"sniperTower100.atf"},
		"name":{"EN":"sniper tower",
				"FR":"tourelle de sniper"},
		"description":{"EN":"The sniper tower is defense tower with long-range.",
					   "FR":"La tourelle de sniper est une tourelle de défense de longue portée."},
		"build":{
			"chooseLocation":true,
			"buildable":"all",
			"costRessource":{"plank":150, "steel":50},
			"costPrimaryCharacteristic":{"stamina":2},
			"sound":"soundBuilding",
			"bonusSkill":"building",
			"xpSkill":{"building":2},
			"xpSecondaryCharacteristic":{"strength":2},
			"prebuild":{"id":"sniperTowerYard", "time":1}
		},
		"repair":{
			"health":20,
			"time":2,
			"costRessource":{"plank":1, "steel":1},
			"costPrimaryCharacteristic":{"stamina":4},
			"sound":"soundBuilding",
			"bonusSkill":"repairing",
			"xpSkill":{"repairing":4},
			"xpSecondaryCharacteristic":{"endurance":4}
		},
		"death":{
			"effect":{"name":"destruction", "scale":1.25}
		},
		"width":64,
		"height":128,
		"visualHeight":160,
		"health":2000,
		"attack":560, "attackTime":4.5, "range":1000, "missile":"cartridge", "attackDY":-104, "sound":"soundGun",
		"damage":["missile", "piercing"],
		"defense":200,
		"resistance":{"fire":2, "death":0.5, "electricity":1.5, "explosion":2, "poison":0}
	},
	"sniperTowerYard":{
		"type":"prebuild",
		"picture":{"file":"sniperTowerYard.png",
				   "file100":"sniperTowerYard100.atf"},
		"name":{"EN":"sniper tower",
				"FR":"mirador"},
		"description":{"EN":"The sniper tower is defense tower which shoot bullet to enemies.",
					   "FR":"Le mirador est une tourelle de défense qui tire des balles sur vos ennemis."},
		"death":{
			"effect":{"name":"destruction", "scale":1.25}
		},
		"width":64,
		"height":128,
		"visualHeight":160,
		"defense":200,
		"resistance":{"fire":2, "death":0.5, "electricity":1.5, "explosion":2, "poison":0},
		"steps":0
	},
	"siegeGolem":{
		"type":"buildingMonster",
		"age":"steamAge",
		"no":16,
		"picture":{"file":"siegeGolem.png",
				   "file100":"siegeGolem100.atf"},
		"name":{"EN":"siege golem",
				"FR":"golem de siège"},
		"description":{"EN":"The siege golem is an over-armed golem with long-range missiles and machine guns.",
					   "FR":"Le golem de siege est un golem surarmé équipé de missiles longue portée et de mitrailleuses."},
		"pluralName":{"EN":"siege golems",
					  "FR":"golems de siège"},
		"build":{
			"chooseLocation":true,
			"buildable":"all",
			"costRessource":{"steel":600},
			"costPrimaryCharacteristic":{"stamina":3},
			"sound":"soundBuilding",
			"bonusSkill":"golemology",
			"xpSkill":{"golemology":3},
			"xpSecondaryCharacteristic":{"intelligence":3},
			"prebuild":{"id":"siegeGolemYard", "time":1.5}
		},
		"repair":{
			"health":8,
			"time":1.5,
			"costRessource":{"steel":1},
			"costPrimaryCharacteristic":{"stamina":3},
			"sound":"soundBuilding",
			"bonusSkill":"golemology",
			"xpSkill":{"golemology":3},
			"xpSecondaryCharacteristic":{"intelligence":3}
		},
		"death":{
			"effect":{"name":"destruction", "scale":1.25}
		},
		"width":90,
		"height":96,
		"visualHeight":120,
		"health":4200,
		"attack":600, "attackTime":6, "attackEffect":"default",
		"damage":["closeCombat", "crushing"],
		"attacks":[{"attack":800, "attackTime":50, "damage":["missile", "explosion"], "range":675, "missile":"bigMissile",  "sound":"soundRocket", "attackDY":-80, "special":{"fixedAngle":-1.57, "selfGuided":0.1, "pierce":true}},
				   {"attack":400, "attackTime":20, "damage":["missile", "explosion"], "range":675, "missile":"microMissile", "sound":"soundRocket", "attackDX":-30, "attackDY":-90, "special":{"fixedAngle":-3.07, "selfGuided":0.125}},
				   {"attack":400, "attackTime":20, "damage":["missile", "explosion"], "range":675, "missile":"microMissile", "sound":"soundRocket", "attackDX":-26, "attackDY":-94, "special":{"fixedAngle":-2.57, "selfGuided":0.125}},
				   {"attack":400, "attackTime":20, "damage":["missile", "explosion"], "range":675, "missile":"microMissile", "sound":"soundRocket", "attackDX":-22, "attackDY":-98, "special":{"fixedAngle":-2.32, "selfGuided":0.125}},
				   {"attack":400, "attackTime":20, "damage":["missile", "explosion"], "range":675, "missile":"microMissile", "sound":"soundRocket", "attackDX":-18, "attackDY":-102, "special":{"fixedAngle":-2.07, "selfGuided":0.125}},
				   {"attack":400, "attackTime":20, "damage":["missile", "explosion"], "range":675, "missile":"microMissile", "sound":"soundRocket", "attackDX":18, "attackDY":-102, "special":{"fixedAngle":-1.07, "selfGuided":0.125}},
				   {"attack":400, "attackTime":20, "damage":["missile", "explosion"], "range":675, "missile":"microMissile", "sound":"soundRocket", "attackDX":22, "attackDY":-98, "special":{"fixedAngle":-0.77, "selfGuided":0.125}},
				   {"attack":400, "attackTime":20, "damage":["missile", "explosion"], "range":675, "missile":"microMissile", "sound":"soundRocket", "attackDX":26, "attackDY":-94, "special":{"fixedAngle":-0.57, "selfGuided":0.125}},
				   {"attack":400, "attackTime":20, "damage":["missile", "explosion"], "range":675, "missile":"microMissile", "sound":"soundRocket", "attackDX":30, "attackDY":-90, "special":{"fixedAngle":-0.07, "selfGuided":0.125}},
				   {"attack":100, "attackTime":9, "damage":["missile", "piercing"], "range":200, "missile":"cartridge", "sound":"soundGun", "attackDX":-36, "attackDY":-56},
				   {"attack":100, "attackTime":9, "damage":["missile", "piercing"], "attackDelay":0.1, "range":200, "missile":"cartridge", "sound":"soundGun", "attackDX":-36, "attackDY":-56},
				   {"attack":100, "attackTime":9, "damage":["missile", "piercing"], "attackDelay":0.2, "range":200, "missile":"cartridge", "sound":"soundGun", "attackDX":-36, "attackDY":-56},
				   {"attack":100, "attackTime":9, "damage":["missile", "piercing"], "range":200, "missile":"cartridge", "sound":"soundGun", "attackDX":36, "attackDY":-56},
				   {"attack":100, "attackTime":9, "damage":["missile", "piercing"], "attackDelay":0.1, "range":200, "missile":"cartridge", "sound":"soundGun", "attackDX":36, "attackDY":-56},
				   {"attack":100, "attackTime":9, "damage":["missile", "piercing"], "attackDelay":0.2, "range":200, "missile":"cartridge", "sound":"soundGun", "attackDX":36, "attackDY":-56}],
		"defense":500,
		"resistance":{"death":0.5, "electricity":1.5, "explosion":2, "golemKiller":4, "poison":0},
		"speed":4
	},
	"siegeGolemYard":{
		"type":"prebuild",
		"picture":{"file":"siegeGolemYard.png",
				   "file100":"siegeGolemYard100.atf"},
		"name":{"EN":"siege golem",
				"FR":"golem de siège"},
		"description":{"EN":"The siege golem is an over-armed golem with long-range missiles and machine guns.",
					   "FR":"Le golem de siege est un golem surarmé équipé de missiles longue portée et de mitrailleuses."},
		"death":{
			"effect":{"name":"destruction", "scale":1.25}
		},
		"width":90,
		"height":96,
		"visualHeight":120,
		"defense":500,
		"resistance":{"fire":1.5, "death":0.5, "electricity":1.5, "explosion":2, "poison":0},
		"steps":7
	}
}